# Word & Will

**A solo tabletop RPG powered by language, played with an AI Game Master.**

In Word & Will, you are a Scribe — someone who wields the power of words to reshape reality. Spoken commands, written inscriptions, whispered secrets, and thunderous utterances are your weapons, tools, and lifeline. Your AI Game Master guides you through adventures in the Lexicon, a world where language is the deepest form of power.

---

## How to Play

1. **Upload this entire zip file** to a new conversation with Claude.
2. Claude will read the rules, GM instructions, characters, and adventures.
3. **Choose a pre-generated character** from the `characters/` folder, or create your own using the rules in `rules.md`.
4. **Choose an adventure** from the `adventures/` folder, or ask Claude to improvise one.
5. **Play.** Claude handles all the rules, dice rolls, NPCs, and narration. You just tell Claude what your character does.

That's it. No dice, no character sheets to maintain, no prep. Just you and the story.

---

## Quick Start

**Fastest way to begin:**

> "I'd like to play Word & Will. Let's use character-01 and adventure-01."

**If you want to browse first:**

> "I'd like to play Word & Will. Can you give me a brief summary of each character?"

**If you want to make your own character:**

> "I'd like to play Word & Will. Can you help me create a custom character?"

---

## What's in This Package

| File | Description |
|------|-------------|
| `README.md` | This file — how to play |
| `rules.md` | Complete game rules — magic system, combat, chases, social encounters, and more |
| `gm-prompt.md` | Instructions for Claude on how to run the game |
| `characters/` | 14 pre-generated characters with diverse playstyles |
| `adventures/` | Pre-built adventures designed for ~1 hour of solo play |

---

## About the Game

- **Players:** 1 (solo, with Claude as GM)
- **Session Length:** ~1 hour
- **Audience:** 18+ adults
- **Genre:** Fantasy with linguistic/literary magic
- **Tone:** Mature, atmospheric, flexible — ranges from wonder to darkness based on player preference
- **Mechanics:** Light, narrative-focused, easy to learn

### The Five Disciplines of Word-Magic

| Discipline | Style |
|------------|-------|
| **Naming** | Know the true name of a thing to command it |
| **Inscription** | Write words of power onto the world |
| **Rhetoric** | Persuade reality itself through speech |
| **Whispering** | Subtle magic of secrets and illusions |
| **Utterance** | Raw vocal force — shouts, commands, shockwaves |

---

## Tips for Players

- **Be descriptive.** The more you describe your character's actions and words, the richer the story becomes. You don't need to write poetry — but "I shout the true name of the door" is more fun than "I use Naming on the door."
- **Think creatively.** The magic system is freeform. If you can justify it through language, you can probably try it.
- **Engage with NPCs.** Talk to people. Ask questions. This world rewards curiosity.
- **Don't be afraid to fail.** Failures create the most interesting stories.
- **Play your character.** Lean into their personality, fears, and motivations. The GM will respond to who your character is, not just what they do.

---

## Credits

**Word & Will** was designed as a solo AI-GM tabletop RPG system.

- Game Design & Writing: Created with Claude (Anthropic)
- System: Built for play with Claude as Game Master
- Inspired by: the long tradition of solo RPGs, journaling games, and the belief that language is magic

---

*"In the beginning was the Word, and the Word was with power, and the Word was power."*
*— First line of the Scribe's Oath*
