# Adventure 01: The Silence of Ashenmere

**Estimated Duration:** ~1 hour
**Tone:** Mystery, creeping dread, moral choices
**Best For:** Any character, but especially rewarding for Naming, Whispering, or investigation-focused builds

---

## Premise

The village of Ashenmere has gone quiet. Not figuratively — literally. Three days ago, the words stopped working. Spoken language dissolves into static. Written text bleeds off the page. The village's Scribe, an elderly Inscriber named Morath, sent a final letter before the silence took hold: *"Something is eating the words. I can feel it underneath the village. Please. Before there's nothing left to say."*

The player character arrives at the edge of Ashenmere as the sun sets. The silence is palpable — a pressure against the ears, like being underwater. The village is visible in the distance, lanterns lit but no sound carrying from it. The last road sign before the village has already been affected: the letters are smeared and running, as though the wood itself is weeping ink.

---

## Key Scenes

### Scene 1: The Edge of Silence

**Setup:** The player approaches Ashenmere and encounters the boundary of the Silence — a visible line where sound and text stop functioning normally. Crossing it means their spoken magic will be impaired.

**The Boundary:** A shimmer in the air, like heat haze. On one side, normal reality. On the other, muffled sound and bleeding text. Word-magic functions at **Disadvantage** within the Silence unless the caster finds a workaround.

**Choices:**
- Cross immediately and head for the village
- Investigate the boundary itself (Script roll, Moderate — reveals the Silence is expanding outward at roughly a foot per hour)
- Try to communicate with the Silence as a magical entity (Naming roll, Hard — reveals it's not a spell but a creature, something alive and hungry)
- Circle around looking for another way in

**NPCs at the Boundary:**
- **Tomas Birch**, a farmer who fled the village. Terrified, inarticulate (the Silence has partially affected his speech even outside the boundary). Can convey through gestures and fragments that "something came up from the well" and "Morath tried to stop it."

### Scene 2: The Silent Village

**Setup:** The village is populated but paralyzed. Villagers huddle in their homes, unable to speak clearly. Written signs, shop names, and notices are illegible — the text has crawled off surfaces and pooled in gutters like spilled ink.

**Key Locations:**

**The Square:** The village center, where pooled ink-text has gathered in a dark puddle around the well. The well is the epicenter of the Silence. Getting close to it intensifies the effect — at the well's edge, even thought becomes sluggish.

**Morath's Workshop:** The old Scribe's home and workshop. The door is warded, but the ward is failing — the inscription is half-dissolved. Inside: Morath's research notes (partially legible, requiring a Moderate Script roll to reconstruct). The notes reveal that Morath discovered something beneath the village while digging a new cellar — a chamber covered in writing in a language that predates the Five Disciplines. He opened it. He shouldn't have.

**The Inn (The Spoken Word):** Ironic name. A few villagers have gathered here. They can communicate through gestures and objects. The innkeeper, **Dalla**, is pragmatic and frightened. She'll help the player if they show competence. She has a set of old hand-signs (a pre-linguistic communication system) that work within the Silence.

**The Well:** Descending into the well requires Resolve (Moderate) to resist the intensifying Silence. At the bottom, a tunnel leads to the chamber Morath found.

### Scene 3: The Chamber Below

**Setup:** An underground chamber, roughly circular, its walls covered in dense, spiraling text in an unknown language. The text is alive — it writhes, rearranges itself, and seems to be actively consuming any new language it encounters. At the center of the chamber is the source of the Silence: a **Hollowed Word**.

**The Hollowed Word:** A creature born from language that was never finished — a word started and never completed, a sentence abandoned mid-thought. Over centuries, buried and forgotten, it grew into a thing of hunger: a living absence of meaning that feeds on language to try to complete itself. It's not evil — it's desperate. It's been trying to finish its own sentence for a thousand years.

**Appearance:** A shifting, translucent shape like a three-dimensional letter that keeps changing — now an "A," now an unrecognizable glyph, now a symbol from no known alphabet. Where it touches language, the words dissolve and are absorbed.

**Threat Rating:** 3 (but conventional attacks are ineffective — it's made of absence, not substance)

**Approaches to Resolution:**

1. **Complete the Word** (Naming, Hard): If the player can determine what the Hollowed Word was meant to be and speak its completion, the creature becomes whole and dissipates — a word finally finished. This is the most narratively satisfying resolution. Requires investigation of the chamber's text (Script, Moderate) to find fragments of the original unfinished sentence.

2. **Bind It** (Inscription, Hard): The player inscribes a containment circle using the pre-Discipline text on the chamber walls as a template. This doesn't destroy the Hollowed Word but traps it again. It worked for a thousand years; it might work again. But is it right to condemn a thinking being to another millennium of incompletion?

3. **Banish It** (Utterance, Dire): The player speaks a word of such overwhelming force that it drowns out the Silence. This destroys the Hollowed Word entirely — an act of linguistic violence that ends the threat but also destroys a unique being and the pre-Discipline text on the chamber walls.

4. **Negotiate** (Rhetoric, Hard): The player speaks to the Hollowed Word, despite the Silence, and tries to convince it to stop feeding. This is difficult because the creature can barely communicate — it speaks in fragments and half-thoughts. But if the player can establish a dialogue, they might find a compromise: feed it a lesser text (a book, a scroll, the player's own words) to sate it temporarily while a permanent solution is sought.

5. **Feed It Morath** (Dark option): Morath is in his workshop, catatonic from exposure to the Silence. He's a living repository of written knowledge — his memories contain thousands of texts. Feeding him to the Hollowed Word would give it enough language to complete itself, but at the cost of a man's mind.

### Scene 4: Aftermath

**Based on the resolution chosen:**

- **Completed the Word:** The Silence breaks like a held breath released. Sound and text return to Ashenmere immediately. The chamber walls go dark as the pre-Discipline text fades — but the player character remembers fragments of it. Morath recovers partially. The village celebrates.

- **Bound It:** The Silence recedes to the chamber, contained but not eliminated. Ashenmere recovers, but the well is sealed permanently. Morath recovers but is haunted by what he released. The player knows the binding won't last forever.

- **Banished It:** The Silence shatters violently — a shockwave of sound that breaks windows throughout the village. Everyone recovers immediately, but the ancient text is lost forever. Morath recovers fully. The player may wonder if they destroyed something irreplaceable.

- **Negotiated:** The Silence lessens but doesn't fully lift — Ashenmere is permanently quieter, a village where people speak softly and write small. The Hollowed Word slumbers, fed but not satisfied. A temporary peace. Morath recovers slowly.

- **Fed Morath:** The Silence breaks completely. Morath's body survives but his mind is empty — he smiles, eats, sleeps, but never speaks or writes again. The village recovers but mourns. The player carries this choice.

---

## NPCs

| NPC | Role | Personality |
|-----|------|-------------|
| **Tomas Birch** | Farmer, first contact | Scared, helpful, limited speech |
| **Morath** | Village Scribe | Elderly, brilliant, catatonic (may recover based on resolution) |
| **Dalla** | Innkeeper | Pragmatic, brave, knows old hand-signs |
| **The Hollowed Word** | The "antagonist" | Not evil — desperate, hungry, incomplete. Communicates in fragments |

---

## Hooks for Different Character Types

- **Naming characters** can attempt to identify the Hollowed Word directly, making the "Complete the Word" path more accessible.
- **Inscription characters** excel at the binding option and can read the chamber's ancient text more easily.
- **Rhetoric characters** have the best shot at negotiation and can communicate despite the Silence through sheer force of persuasion.
- **Whispering characters** can navigate the Silence more easily (Whispering is already quiet) and may be able to hear the Hollowed Word's fragmented speech.
- **Utterance characters** can brute-force through the Silence with raw vocal power, but their natural approach (destroy it with force) has consequences.
- **Investigation-focused characters** benefit from the mystery structure and the research required to find the best solution.
- **Combat-focused characters** face a challenge: this enemy can't be fought conventionally. They'll need to adapt.

---

## GM Notes

- The Silence should feel oppressive but not frustrating. Give the player creative latitude to work around the magical impairment.
- The Hollowed Word is sympathetic. Play it as a being in pain, not a monster. Its hunger is tragic, not malicious.
- There is no "right" answer. Each resolution has costs and benefits. Let the player grapple with the choice.
- Pacing: Scene 1 should be quick (10 min), Scene 2 is exploration (20 min), Scene 3 is the climax (20 min), Scene 4 is resolution (10 min).
- If the player is struggling with the Silence mechanic, have Dalla's hand-signs provide a workaround, or let clever spell descriptions bypass the Disadvantage.
