# Adventure 02: The Auction of Unspeakable Things

**Estimated Duration:** ~1 hour
**Tone:** Intrigue, heist elements, social maneuvering, moral tension
**Best For:** Any character, but especially rewarding for Rhetoric, Whispering, or socially focused builds

---

## Premise

An invitation arrives — gilt-edged, written in ink that shifts color as you read it. You've been invited to the Inkwell Auction, a semi-legal underground market where rare and dangerous magical texts, artifacts, and services are bought and sold. The auction is held in the traveling estate of **Madame Calix Sorel**, a notorious collector and dealer in forbidden knowledge. The estate appears in a different city each month, staying for one night only.

Your reason for attending: **Lot 47** — a living manuscript called *The Confessions of the First Scribe*. It's said to be the autobiography of the person who first divided the original language of magic into the Five Disciplines. It writes itself continuously, adding new pages. It remembers everything. And if the wrong person buys it, the knowledge inside could destabilize the entire power structure of the Lexicon.

You don't have enough money to buy it legitimately. So you'll have to get creative.

---

## Key Scenes

### Scene 1: Arrival at the Inkwell

**Setup:** The estate materializes at dusk in an empty lot — a sprawling, baroque mansion that wasn't there yesterday and won't be there tomorrow. A line of well-dressed, dangerous-looking people file through the front doors. The invitation is your ticket in.

**The Entrance:** A large foyer where guests are checked for weapons (mundane ones only — magical armament is expected and tolerated). The doorman, **Sev**, is a huge man with Inscription tattoos covering his arms and neck. He's polite, professional, and clearly a walking weapon.

**The Rules of the Inkwell:**
1. No violence within the estate. Madame Sorel's inscriptions enforce this — aggressive magic fails, weapons lock in their sheaths.
2. All transactions are binding. A bid, once placed, cannot be withdrawn.
3. The Madame's word is final in all disputes.
4. Guests may browse, socialize, and negotiate freely before the auction begins.

**Choices:**
- Enter through the front (straightforward, but everyone sees you)
- Look for a servants' entrance or alternate way in (Wit roll, Moderate)
- Arrive early and try to case the estate before other guests arrive (Whispering roll, Moderate)

### Scene 2: The Gallery

**Setup:** Before the auction begins, guests mingle in the Gallery — a grand hall where lesser lots are displayed for preview. This is the social arena where alliances are formed, rivals are assessed, and information is currency.

**Key NPCs in the Gallery:**

**Madame Calix Sorel** — The host. Ageless appearance, silver hair, eyes that reflect ink instead of light. She speaks in perfectly crafted sentences — every word chosen, every pause deliberate. She's not cruel, but she values interesting people and has no patience for boring ones. She knows everything about everyone in the room and will share information if sufficiently entertained. *Disciplines: All five (rumored). Threat Rating: 5.*

**Aldric Voss** — A representative of the Athenaeum of Deep Script. Officially, the Athenaeum doesn't acknowledge the Inkwell's existence. Unofficially, Aldric is here with a deep purse and instructions to acquire Lot 47 at any cost. He's nervous, out of his element, and trying very hard to look like he belongs. *Threat Rating: 2.*

**The Twins, Ink and Blot** — Identical twins who share a single Naming identity (a magical anomaly). They finish each other's sentences, sometimes speak in unison, and are bidding on Lot 47 for an unnamed third party. They are unsettling, competent, and amused by everything. *Threat Rating: 3 (each), 4 (together).*

**Asha Dreen** — A former Scribe turned revolutionary who wants Lot 47 to expose the Lexicon's power structure. She's idealistic, passionate, and willing to do things the player might not be comfortable with. She might be an ally — but her endgame is chaos. *Threat Rating: 3.*

**Information Available in the Gallery:**

*Use the Social Encounters framework from the rules. The Gallery is a textbook social scene — apply the three Information Tiers (Free / Available / Guarded) and assign NPC Secrets as listed below.*

- Lot 47 is kept in a sealed room behind the auction stage. The room is warded with at least three layers of Inscription (Hard to bypass).
- Madame Sorel has a weakness: she's a collector of first lines. The opening sentence of any text fascinates her. A sufficiently compelling first line might earn her favor.
- Aldric Voss is carrying a letter of credit from the Athenaeum worth 10,000 silver marks. If it were to be "lost," the Athenaeum's bid would collapse.
- The Twins can be bargained with, but they only accept trades — they don't care about money. What they want is a secret: a true name they don't already know.
- Asha has planted a disruption device somewhere in the estate — if the auction goes badly for her, she intends to create chaos and grab Lot 47 in the confusion.

### Scene 3: The Auction

**Setup:** Guests file into the auction hall. Madame Sorel presides from an elevated platform. Lots are presented one by one. Lot 47 is the final item — the headliner.

**Auction Mechanics:**

The player cannot outbid the major players financially. They need to use one (or more) of these approaches:

1. **Discredit a Rival's Bid** (Rhetoric or Whispering): Expose Aldric's Athenaeum connection (the Inkwell frowns on institutional buyers), or reveal something about the Twins' employer that makes Sorel reluctant to sell to them. Requires information gathered in Scene 2.

2. **Steal the Letter of Credit** (Wit or Whispering): If Aldric's funding is removed, the Athenaeum's bid collapses. This requires getting close to him, identifying where the letter is, and taking it without triggering the no-violence wards. (The wards prevent aggression, not theft — a loophole.)

3. **Make a Trade** (Rhetoric + Naming): Offer Madame Sorel something more valuable than money. Possibilities: a true name she doesn't know, a first line she's never heard, a secret about the Lexicon's history, or a future favor. The player needs to determine what Sorel values and pitch accordingly (Voice roll, Hard).

4. **Alliance with Asha** (Rhetoric): Join Asha's plan to disrupt the auction. This is effective but dangerous — Asha's disruption device will temporarily nullify the estate's wards, meaning violence becomes possible. The ensuing chaos is an opportunity to grab Lot 47, but people could get hurt.

5. **Convince Lot 47 Itself** (Naming, Hard): The manuscript is alive. It has opinions about who should read it. If the player can get to the sealed room and communicate with the manuscript, they might convince it to choose them — and a living manuscript that chooses its owner is, by Inkwell convention, not for sale.

6. **Win Through Reputation** (Rhetoric, Dire): Make such an impression during the auction that Madame Sorel decides the player is the most interesting person in the room and offers Lot 47 as a gift. This is nearly impossible but profoundly satisfying if pulled off.

### Scene 4: The Aftermath

**Based on the approach taken:**

- **Discredited a rival:** The auction continues with reduced competition, and the player may win with a modest bid or a creative offer. Clean resolution, but the discredited rival becomes a future enemy.

- **Stole the letter of credit:** Aldric is humiliated and the Athenaeum loses its bid. The player must still win the auction, but the competition is thinner. Aldric may realize what happened and confront the player.

- **Made a trade:** Sorel accepts the offer and awards Lot 47 directly. The player has what they came for, but Sorel now has something of the player's — and Sorel collects debts.

- **Allied with Asha:** Chaos erupts. The player has a window to grab Lot 47, but must navigate a suddenly violent environment. Asha may or may not make it out. Other guests may be injured. The player leaves with the manuscript and a complicated conscience.

- **Convinced the manuscript:** Lot 47 chooses the player. Sorel is annoyed but respects the convention. The player leaves with a living manuscript that has its own personality, opinions, and tendency to add commentary to everything the player does. (This becomes a narrative companion in future sessions.)

- **Won through reputation:** The rarest outcome. Sorel is delighted, the room is stunned, and the player walks out with Lot 47 and an invitation to return to any future Inkwell. They've made a powerful friend — and many jealous enemies.

**The Manuscript:** However acquired, *The Confessions of the First Scribe* is a complex artifact. It contains dangerous knowledge about the origin of the Five Disciplines. It adds pages continuously. It has a personality — sardonic, ancient, tired of being locked up. It becomes a narrative element in future adventures, offering commentary, historical context, and occasionally cryptic warnings.

*Use the Sentient Objects framework from the rules. Lot 47's starting stats:*
- *Disposition: Wary (if taken by force or trade) / Friendly (if it chose the player)*
- *Requirements: Wants to be read, discussed, and treated as a person — not a tool or a prize*
- *Limits: Will not reveal knowledge it believes would cause mass harm. Will withhold chapters it considers "not ready" for the reader*

---

## NPCs

| NPC | Role | Personality |
|-----|------|-------------|
| **Madame Calix Sorel** | Host, collector | Refined, omniscient, values intrigue |
| **Sev** | Doorman, enforcer | Polite, professional, terrifying |
| **Aldric Voss** | Athenaeum agent | Nervous, out of his depth, well-funded |
| **Ink and Blot** | Mysterious twins | Unsettling, amused, competent |
| **Asha Dreen** | Revolutionary | Idealistic, dangerous, willing to burn things down |
| **Lot 47** | Living manuscript | Sardonic, ancient, opinionated (if the player interacts with it) |

---

## Hooks for Different Character Types

- **Rhetoric characters** thrive here — the entire adventure is a social arena. Every approach involves persuasion, manipulation, or negotiation.
- **Whispering characters** can gather information, eavesdrop on rivals, and execute the theft approach with ease.
- **Naming characters** have the unique option of communicating with Lot 47 directly and can offer Sorel a true name as trade.
- **Inscription characters** can analyze the estate's wards, potentially find weaknesses, and appreciate the craftsmanship of Sorel's protections.
- **Utterance characters** face a challenge — the no-violence wards neutralize their primary tool. They'll need to adapt and use their Voice attribute for social purposes instead of force. If Asha's disruption activates, they suddenly become the most dangerous person in the room.
- **Combat-focused characters** are deliberately out of their comfort zone. The adventure rewards social adaptation.

---

## GM Notes

- This adventure is a social sandbox. Let the player explore, talk to NPCs, and formulate their own plan. Don't railroad them toward a specific approach.
- Madame Sorel should feel like the most powerful person in the room. She's not an antagonist — she's an arbiter. She respects cleverness and despises boredom.
- The Twins are meant to be memorable and slightly creepy. They're not villains, just strange.
- Asha is a moral test. Her goals are sympathetic, but her methods are reckless. Allying with her should feel tempting and uncomfortable.
- Lot 47 is the adventure's wild card. If the player interacts with it, play it as a character — ancient, weary, and sick of being treated as property.
- Pacing: Scene 1 is quick (5–10 min), Scene 2 is the longest (25–30 min, the social exploration phase), Scene 3 is the climax (15–20 min), Scene 4 is resolution (5–10 min).
- If the player is struggling to find an approach, have an NPC (Asha is best for this) offer an alliance or suggest a lead.
