# Adventure 03: The Last Translation

**Estimated Duration:** ~1 hour
**Tone:** Exploration, wonder, philosophical tension, escalating danger
**Best For:** Any character, but especially rewarding for Script-heavy builds, Naming specialists, and players who enjoy exploration and moral choices

---

## Premise

A dying linguist named **Yvara Saltmere** has sent you her life's work: a partial translation of the **Tongue Before Tongues** — the original, undivided language of magic that existed before the Five Disciplines were created. She's cracked enough of it to identify a location: the **Scriptorum**, an ancient structure buried beneath the Greywash Badlands where the first words of power were spoken. Yvara believes the Scriptorum contains the complete Tongue Before Tongues — and that someone deliberately buried it to keep the language fragmented.

Yvara is too ill to make the journey. She's entrusted you with her translation key and her notes, and asked you to reach the Scriptorum, find the original language, and bring it back. What you do with it after that — publish it, destroy it, or keep it — is your choice.

But you're not the only one looking. The **Redactors** — an ancient order dedicated to keeping the Five Disciplines divided — have learned of Yvara's breakthrough. They're coming to destroy the Scriptorum and everything inside it. You have maybe a day's head start.

---

## Key Scenes

### Scene 1: The Greywash

**Setup:** The Greywash Badlands are a desolate stretch of eroded stone and dry riverbeds. Nothing grows here. The rock is covered in faded inscriptions — fragments of ancient text worn down by centuries of wind. Yvara's notes indicate the Scriptorum entrance is marked by a specific inscription that can only be read with her translation key.

**The Journey:** A brief travel scene. The Badlands are hostile — extreme heat during the day, freezing cold at night, and the constant low hum of ancient magic radiating from the inscribed stone.

**Encounter — The Echoes:** The inscriptions in the Badlands aren't just decorative. They're fragments of spells cast so long ago that only their echoes remain. As the player travels, the echoes manifest as sensory phenomena: phantom voices reciting numbers in an unknown language, brief flashes of light in geometric patterns, the smell of ozone and old paper. A Naming roll (Simple) identifies these as harmless residue. A Script roll (Moderate) reveals that the inscriptions are a navigational system — they point toward the Scriptorum if read in the correct sequence.

**Encounter — Redactor Scout:** A lone figure follows at a distance — **Quill**, a young Redactor sent ahead to scout. Quill is conflicted about the mission (they joined the Redactors out of idealism, not zealotry) and can be confronted, avoided, or potentially turned.

**Quill's Information (if captured or persuaded):** The main Redactor force is half a day behind. Led by **Assessor Renn**, a veteran Redactor who has destroyed three pre-Discipline sites. Renn's team includes six Redactors armed with Erasure magic — specialized Naming that unmakes written text and the objects it's inscribed on. Renn is methodical, ruthless, and genuinely believes that reuniting the original language would end civilization.

### Scene 2: The Scriptorum Entrance

**Setup:** Yvara's directions lead to a cliff face covered in dense, layered inscriptions. Among them, visible only through the translation key, is a sentence that reads: *"Speak yourself truly, and enter."*

**The Door:** The entrance responds to truth. The player must make a truthful statement about themselves — not a fact, but a genuine self-revelation. The more honest and vulnerable the statement, the easier the entrance opens. The GM should prompt the player to speak as their character.

- **A surface truth** ("I am a Scribe"): The door opens partially, enough to squeeze through. Hard Resolve roll to push through.
- **A meaningful truth** ("I am afraid of what I'll find"): The door opens fully.
- **A deep truth** ("I came here because I don't know who I am without my magic"): The door opens and the Scriptorum lights up in welcome. Advantage on the first roll inside.

This is a character-defining moment. Let the player take their time with it.

### Scene 3: Inside the Scriptorum

**Setup:** The Scriptorum is vast — a cathedral-sized underground chamber with walls, floor, and ceiling covered in continuous, flowing text in the Tongue Before Tongues. The text moves — it breathes, shifts, and rearranges itself like a living document. The air tastes like thunderstorms and old libraries. The magic here is palpable, pressing against the skin like static electricity.

**The Structure:**

The Scriptorum has three sections, each containing a piece of the original language:

**The Hall of Naming:** A long corridor where the true names of all things are written — not just creatures and objects, but concepts. The name of "justice," the name of "sorrow," the name of "time." Reading these names aloud produces profound effects. The player can learn one true name of an abstract concept (incredibly powerful, once per session in future play). But reading carelessly triggers defense mechanisms: **Name Guardians**, constructs of living text that attack by speaking the true name of the intruder's fears. *Threat Rating: 3.*

**The Inscription Cradle:** A circular chamber where the first inscriptions were written. The walls are covered in ur-inscriptions — the templates from which all Inscription magic descends. A skilled Inscriber can copy one template (Script roll, Hard), gaining a single-use ur-inscription of immense power. But the templates are fragile — copying them incorrectly could destroy the original. A failure doesn't just mean a bad copy; it means a piece of the original language is lost forever.

**The Speaking Chamber:** The deepest room, where the first words were spoken. The chamber is perfectly silent until someone speaks — then it amplifies and transforms the words, revealing their deepest meaning. Speaking here is both illuminating and dangerous. Any lie spoken in the Speaking Chamber becomes instantly and painfully obvious to the speaker. Any truth spoken becomes a minor spell effect. This is where the complete Tongue Before Tongues can be heard — if the player is willing to listen.

**The Tongue Before Tongues:** In the Speaking Chamber, the complete original language manifests as a **voice** — not a recording, but a presence. It speaks to the player, answering questions in a language that is understood intuitively rather than translated. It reveals:

1. The Five Disciplines were created by a council of ancient Scribes who feared that the complete language was too powerful for individuals to wield.
2. The division was an act of protection — and control.
3. The language can be reunited, but doing so would rewrite the rules of magic for everyone in the Lexicon — not just the player.
4. Reunification has consequences. The original language is more powerful but also more demanding. Scribes who can't handle it would lose their abilities entirely.

The voice asks the player a question: *"What would you do with a word that could change everything?"*

### Scene 4: The Redactors Arrive

**Setup:** As the player explores the Scriptorum, the Redactors arrive. Assessor Renn and their team enter the structure and begin systematically destroying the text on the walls with Erasure magic. The player hears the destruction — a sound like tearing paper magnified a thousandfold.

**The Clock:** Once the Redactors enter, the player has limited time. The destruction advances from the entrance inward. The player must make choices:

**Confrontation Options:**

1. **Fight the Redactors** (Combat): Assessor Renn is Threat Rating 4. The six Redactors are Threat Rating 2 each but fight as a coordinated unit. Inside the Scriptorum, the player has environmental advantages — the living text can be weaponized (Inscription, Moderate), the Name Guardians can be turned against the Redactors (Naming, Hard), and the Speaking Chamber amplifies all magic (Advantage on rolls while inside it).

2. **Seal the Scriptorum** (Inscription, Hard): Use the ur-inscriptions to seal the entrance, trapping the Redactors outside (or inside, depending on positioning). This preserves the Scriptorum but doesn't resolve the Redactor threat permanently.

3. **Negotiate with Renn** (Rhetoric, Hard): Renn is a true believer, but they're also intelligent. If the player can present a compelling argument for why the original language should survive (or at least not be destroyed today), Renn might agree to a temporary ceasefire. Renn's fear — which can be read through Naming — is that reunification will destroy the magical abilities of ordinary Scribes, leaving only the powerful few with access to magic.

4. **Turn Quill** (Rhetoric, Moderate, if Quill was treated well earlier): If the player befriended or showed mercy to Quill in Scene 1, Quill can be convinced to help. Quill knows Renn's tactics and can provide Advantage on rolls against the Redactors, or create a distraction allowing the player to accomplish their goal.

5. **Trigger the Speaking Chamber** (Naming or Voice, Dire): Speak a word in the Tongue Before Tongues, using the chamber's amplification to broadcast it across the Scriptorum. The effects are dramatic and unpredictable — the living text mobilizes against the Redactors, the Name Guardians awaken en masse, and the Scriptorum itself defends itself. This is effective but uncontrollable. The player may be caught in the crossfire.

6. **Let Them Destroy It** (No roll required): The player may choose to let the Redactors succeed. Maybe Renn is right — maybe the original language is too dangerous. The player can take what they've already learned and leave, preserving their personal knowledge while the Scriptorum is erased.

### Scene 5: The Choice

**Setup:** However the Redactor conflict resolves, the player faces a final choice. They have access to some portion of the Tongue Before Tongues — perhaps a complete copy, perhaps fragments, perhaps just memories. What do they do with it?

**Options:**

- **Publish it:** Share the knowledge with the world. This would democratize the original language, empowering everyone — and potentially destabilizing every magical institution in the Lexicon.
- **Give it to the Athenaeum:** The safe, institutional choice. The Athenaeum would study it carefully and probably suppress it, but at least it wouldn't be lost.
- **Keep it:** Personal power. The player alone knows the original language, or pieces of it. This is selfish but practical.
- **Destroy it:** Agree with the Redactors in principle. The original language is too dangerous. Burn the notes, forget what was learned, and let the Five Disciplines continue as they are.
- **Finish Yvara's work:** Return the knowledge to Yvara and let her decide. She's the one who devoted her life to this. She should choose its fate.

---

## NPCs

| NPC | Role | Personality |
|-----|------|-------------|
| **Yvara Saltmere** | Dying linguist (appears via letters/notes) | Brilliant, selfless, trusting |
| **Quill** | Young Redactor scout | Conflicted, idealistic, reachable |
| **Assessor Renn** | Redactor leader | Methodical, ruthless, genuinely believes they're right |
| **The Voice** | The Tongue Before Tongues manifest | Ancient, patient, curious about the player's answer |
| **Name Guardians** | Scriptorum defenses | Constructs of living text; impersonal but dangerous |

---

## Hooks for Different Character Types

- **Naming characters** can interact with the Hall of Naming and the Speaking Chamber most effectively. The Name Guardians are a particular challenge and opportunity.
- **Inscription characters** can copy ur-inscription templates and use the Scriptorum's text as weapons. The Inscription Cradle is their playground.
- **Rhetoric characters** can negotiate with Renn, turn Quill, and engage with the philosophical themes of the adventure.
- **Whispering characters** can scout the Scriptorum quietly, avoid the Redactors, and find hidden sections of text.
- **Utterance characters** are amplified by the Speaking Chamber to devastating effect. The Tongue Before Tongues may respond to raw vocal power.
- **Scholar characters** (like Torren) will find this adventure a dream and a nightmare — the knowledge they've always sought, with a time limit and moral weight.
- **Combat characters** have a clear confrontation path with the Redactors, plus the environmental advantages of fighting inside a living magical structure.

---

## GM Notes

- This adventure has the most lore-heavy content. Deliver it through experience and dialogue, not exposition. Show, don't tell.
- The Scriptorum should feel awe-inspiring. This is a sacred place of language, and the descriptions should convey wonder.
- Renn should be a compelling antagonist — not a villain. Their argument against reunification is valid. The player should have to genuinely consider whether Renn might be right.
- The final choice has no correct answer. Each option has real consequences. Don't steer the player toward any particular choice.
- Pacing: Scene 1 (10 min), Scene 2 (5–10 min), Scene 3 (20–25 min, the exploration/wonder phase), Scene 4 (15 min, the climactic confrontation), Scene 5 (5–10 min, the choice and aftermath).
- If the player is moving slowly through the Scriptorum, remind them of the Redactors' approach — the sound of tearing text growing louder. Urgency should build naturally.
- Quill is the key NPC for players who are struggling. If they treated Quill well, Quill provides assistance. If they ignored or threatened Quill, Quill becomes an additional obstacle. Reward the player's earlier choices.
- If the player tries to flee the Scriptorum with the Redactors in pursuit, use the **Chase** rules from the core rules — 3 checkpoints through the collapsing, text-filled tunnels. The Scriptorum's living text creates excellent checkpoint obstacles and magic opportunities.
