# Brother Erasmus

**Concept:** Excommunicated monk who discovered that prayer is just another form of Rhetoric

---

## Background

Brother Erasmus spent twenty years in the Monastery of the Closed Book, an order devoted to the preservation of dangerous texts. The monks guard words too powerful to speak, names too terrible to know, inscriptions that could unmake cities. Erasmus was a faithful keeper — until he actually read one of the forbidden texts. What he found shattered his faith: the monastery's prayers, their sacred chants, their holy rituals — all of it was Rhetoric magic, dressed in religious vestments. The order wasn't preserving dangerous knowledge; they were hoarding power while pretending to serve a higher purpose. When he confronted the Abbot, he was excommunicated, stripped of his rank, and thrown out with nothing but his robes and his uncomfortable new understanding of the relationship between faith and magic.

---

## Attributes

| Attribute | Value |
|-----------|-------|
| **Voice** | 4 |
| **Script** | 3 |
| **Wit** | 2 |
| **Resolve** | 3 |

---

## Disciplines

- **Proficient:** Rhetoric, Naming

---

## Strain

**Maximum Strain:** 10 (Resolve 3 × 2 + 4)

---

## Starting Spells & Abilities

- **Sermon** (Rhetoric/Common) — Erasmus delivers a brief, impassioned speech that bolsters the courage, morale, or determination of those who hear it. Allies (including himself) gain Advantage on their next Resolve roll.
- **Reveal the Lie** (Naming/Common) — Erasmus speaks the true name of a falsehood, causing it to become visible — lies glow faintly red, illusions flicker, disguises feel wrong. Doesn't dispel the deception, but makes it obvious.
- **Confession** (Rhetoric/Potent) — Erasmus speaks in the cadence of a confessional prayer, and the target feels an overwhelming compulsion to speak their deepest guilt. Even if they resist the compulsion, their body language betrays them.

---

## Equipment

1. Simple monk's robes (surprisingly durable, many pockets)
2. A fragment of the forbidden text he read (Inscribed: contains one Grand-level Naming spell, single use — Erasmus doesn't know what it does, only that it's powerful and frightening)
3. A walking staff carved with protective prayers (Warded: Advantage on Resolve to resist Rhetoric magic)
4. A brass censer that produces calming smoke (Advantage on Voice rolls when used in social scenes)
5. Rope, candles, and flint (practical supplies)
6. A well-worn journal of theological arguments

---

## Personality & Motivation

**Personality:** Thoughtful, conflicted, surprisingly funny. Has the vocal cadence of a preacher but the doubts of a philosopher. Drinks more than he used to. Still habitually kind — he can't shake twenty years of monastic service even if he's lost his faith in its source. Argues with himself out loud.

**Motivation:** Truth. If the monastery's faith was just magic with better branding, what is genuine faith? Is there something real beneath the Rhetoric, or is it words all the way down? He needs to know.

**Fear:** That there's nothing beyond the words. That meaning is just another spell, and he's been casting it his whole life without knowing.

---

## Unique Trait: Crisis of Faith

Erasmus's magic is tangled with his belief — or lack thereof. When he casts a spell with genuine conviction (the GM judges this based on the narrative context), he gains Advantage on the roll. When he casts while conflicted or doubting himself, the GM may impose Disadvantage. This makes his magic wildly inconsistent but capable of extraordinary peaks. The player should lean into this — engage with the doubt, and the moments of clarity become more powerful.

---

## Playstyle

Erasmus is a versatile character who blends social capability with knowledge and investigation. His Rhetoric and Naming combination lets him both influence people and perceive truth, making him excellent in mystery and intrigue scenarios. His variable magical effectiveness (through Crisis of Faith) creates dramatic tension and rewards narrative engagement. Best played by someone who enjoys philosophical themes, characters in moral flux, and the interplay between faith and doubt.
