# Vex Amaranth

**Concept:** Chaotic arcanist who treats magic like jazz — improvisation over precision

---

## Background

Vex was born with a rare condition the Athenaeum calls Lexical Synesthesia — they perceive language as sensation. Written words have texture, spoken words have color, and names taste like something. It's disorienting, occasionally debilitating, and grants them an intuitive understanding of word-magic that formal training can't replicate. Vex bounced between three different magical academies, expelled from each for "wildly unorthodox methodology" (read: they kept setting things on fire by accident while trying to taste the name of the color blue). Now they work as a freelance problem-solver, specializing in situations too weird for conventional Scribes. Their magic is unpredictable, powerful, and occasionally does things nobody expected — including Vex.

---

## Attributes

| Attribute | Value |
|-----------|-------|
| **Voice** | 2 |
| **Script** | 2 |
| **Wit** | 5 |
| **Resolve** | 3 |

---

## Disciplines

- **Proficient:** Naming, Utterance

---

## Strain

**Maximum Strain:** 10 (Resolve 3 × 2 + 4)

---

## Starting Spells & Abilities

- **Synesthetic Surge** (varies/Common) — Vex channels their synesthesia into a burst of magic shaped by the dominant sensation of the moment. The player describes a sensory experience ("the word tastes like copper and fear") and the GM determines the effect based on the description. This is Vex's bread and butter — flexible, creative, unpredictable.
- **Name the Weird** (Naming/Common) — Vex can perceive and identify magical effects, enchantments, curses, and anomalies by their synesthetic signature. They experience the magic's "flavor" and can describe it, giving the GM a prompt to reveal what the magic does.
- **Shout the Colors** (Utterance/Potent) — Vex speaks a word, and the synesthetic color they perceive becomes real — a blast of sound that manifests as visible, tangible light. The color determines the effect (red = heat/fire, blue = cold/stillness, gold = force/impact, etc.).

---

## Equipment

1. A patchwork coat covered in scribbled notes, diagrams, and stains (it's a filing system, not a fashion disaster)
2. Tinted goggles (help manage visual synesthesia; also look cool)
3. A collection of small objects in a belt pouch — a smooth stone, a copper coin, a feather, a glass marble — each with a known synesthetic signature, used as magical focuses
4. A battered sketchbook of synesthetic impressions (Advantage on Wit rolls when referencing a previously encountered magical phenomenon)
5. Chalk (for emergency inscriptions)
6. A sling and bag of stones (Vex's concession to practicality)

---

## Personality & Motivation

**Personality:** Energetic, tangential, deeply curious. Goes on sensory tangents ("Wait, that word smelled different — say it again"). Genuine and open in a way that's either endearing or exhausting depending on your patience. Uses they/them pronouns. Has trouble with social conventions but is genuinely empathetic.

**Motivation:** Understanding. Vex wants to know why they perceive magic differently and whether their synesthesia is a gift, a condition, or something else entirely. There are legends of ancient Scribes who could perceive the "true language" beneath all others — is that what Vex is experiencing?

**Fear:** That their synesthesia will worsen until they can't distinguish reality from magical noise, losing themselves in a cacophony of sensation.

---

## Unique Trait: Controlled Chaos

When Vex casts a spell, the GM rolls an additional d6 (the Chaos Die) alongside the normal roll. On a 6, something unexpected happens — an additional effect, a side effect, or an unintended consequence. The GM determines what this is based on the spell and situation. This extra effect can be beneficial, neutral, or problematic, but should always be interesting. This reflects Vex's unpredictable magic and ensures that playing them is never boring.

---

## Playstyle

Vex is for players who want maximum creative freedom and don't mind unpredictability. Their sky-high Wit makes them excellent at improvisation, quick thinking, and creative problem-solving. Their low Voice and Script mean they struggle with traditional social encounters and scholarly research. The Controlled Chaos trait means every spell is a surprise. Best played by someone who enjoys creative magic use, embraces randomness, and wants to describe their spells in vivid sensory terms.
