# Fen Kallistos

**Concept:** Wandering poet-duelist who fights with verses and treats combat as performance art

---

## Background

In the Free Cities of the Colophon Coast, disputes between Scribes are settled by Verse Duel — a formalized combat where opponents attack and defend using improvised poetry infused with magic. Fen Kallistos is the three-time Colophon Champion, undefeated in thirty-seven official duels. Handsome, flamboyant, and aware of both facts, Fen travels the Lexicon looking for worthy opponents, beautiful scenery, and experiences worth immortalizing in verse. Most people assume Fen is all style and no substance. Most people are wrong — beneath the peacock exterior is a rigorously trained magical duelist whose improvisational skill borders on genius. But there's a hollowness Fen won't admit to: thirty-seven victories, and none of them have silenced the voice in the back of their mind that says the poetry isn't good enough, that the victories are just magic dressed as art.

---

## Attributes

| Attribute | Value |
|-----------|-------|
| **Voice** | 4 |
| **Script** | 2 |
| **Wit** | 4 |
| **Resolve** | 2 |

---

## Disciplines

- **Proficient:** Rhetoric, Utterance

---

## Strain

**Maximum Strain:** 8 (Resolve 2 × 2 + 4)

---

## Starting Spells & Abilities

- **Cutting Verse** (Rhetoric + Utterance/Common) — Fen speaks a line of improvised poetry that manifests as a cutting force — a blade of sound shaped by the verse's emotion. The more artful the line, the sharper the cut.
- **Parry and Riposte** (Rhetoric/Common) — Fen responds to an incoming attack (magical or physical) with a counter-verse that deflects the force and redirects it. Requires a Wit roll; on success, the attack is negated and Fen gains Advantage on their next offensive action.
- **The Standing Ovation** (Rhetoric/Potent) — Fen delivers a performance so compelling that all listeners are momentarily transfixed — friend and foe alike. Lasts only a few seconds, but enough to escape, reposition, or set up a devastating follow-up.

---

## Equipment

1. A rapier with a verse inscribed along the blade — changes daily based on Fen's mood (Named: "Stanza" — +1 to Wit in combat)
2. An outrageously fashionable outfit (changes with each adventure; always impractical, always gorgeous)
3. A small harp (accompaniment for verse dueling; can be used as an improvised weapon in desperation)
4. A leather-bound collection of Fen's own poetry (Advantage on Voice rolls when reciting prepared material)
5. A velvet pouch of coins (Fen is never broke — dueling pays well)
6. A compact mirror (vanity, but also useful for seeing around corners)

---

## Personality & Motivation

**Personality:** Charming, theatrical, competitive. Flirts with anyone they find interesting (which is most people). Uses they/them pronouns. Quotes their own poetry at every opportunity. Beneath the showmanship is a fierce perfectionist who rehearses "improvised" verses for hours. Genuinely kind but hides it behind bravado because vulnerability is the one performance they can't master.

**Motivation:** To write one perfect poem. Not a spell, not a weapon — just a poem that stands on its own merit as art. Every duel, every adventure, every heartbreak is material, and none of it has been enough yet.

**Fear:** Irrelevance. That without the magic, the victories, and the reputation, there's nothing underneath worth knowing.

---

## Unique Trait: Verse Duel

When Fen engages in any form of structured magical combat (a formal duel, a verbal confrontation, or any situation where they can trade attacks back and forth), they gain Advantage on all rolls. This reflects their specialized training. Additionally, if the player actually crafts a line of verse or poetry for their attack (even simple rhyming couplets), the GM should grant Resonance. Fen's magic is performance — the better the performance, the stronger the magic.

---

## Playstyle

Fen is a high-risk, high-reward combat character built around dueling and performance. Their combination of Rhetoric and Utterance gives them both offensive and defensive magical combat abilities, and their Wit makes them excellent improvisers. Weaknesses are low Resolve (small Strain pool, fragile) and low Script (poor at research and preparation). Best played by someone who enjoys theatrical characters, wants to engage with the creative spellcasting system, and doesn't mind crafting the occasional rhyme.
