# Hazel Copperbind

**Concept:** Retired smuggler who hid contraband inside enchanted books and can't quite leave the life behind

---

## Background

For fifteen years, Hazel Copperbind ran the most successful smuggling operation in the Lexicon by hiding goods inside books. Literal goods inside literal books — Inscription magic that folded physical objects into the space between pages, Whispering enchantments that made the books look ordinary, Naming spells that disguised the books' true contents. A crate of illegal spices became a volume of agricultural poetry. A cache of weapons became a children's primer. The authorities never caught on because who searches books? Hazel retired three years ago with enough wealth to live comfortably in a quiet coastal town. She lasted eight months before boredom drove her back to "consulting" — helping people move things that need moving, find things that need finding, and hide things that need hiding. She tells herself each job is the last one.

---

## Attributes

| Attribute | Value |
|-----------|-------|
| **Voice** | 3 |
| **Script** | 4 |
| **Wit** | 3 |
| **Resolve** | 2 |

---

## Disciplines

- **Proficient:** Inscription, Whispering

---

## Strain

**Maximum Strain:** 8 (Resolve 2 × 2 + 4)

---

## Starting Spells & Abilities

- **Bookspace** (Inscription/Common) — Hazel can fold small objects into the pages of a book, hiding them in a pocket of inscribed space. The object is undetectable by normal means and can be retrieved by opening to the right page and speaking a keyword. Limited to objects that would fit in a large suitcase.
- **Unremarkable** (Whispering/Common) — An enchantment that makes an object or small area seem utterly boring and not worth investigating. Customs inspectors skip the enchanted crate, guards overlook the enchanted door, searchers ignore the enchanted pocket. Less effective against people specifically looking for magical concealment.
- **Forger's Eye** (Inscription/Cantrip) — Hazel can instantly identify forged documents, fake inscriptions, or tampered writing. She can also determine the approximate age and origin of any piece of writing.

---

## Equipment

1. A leather messenger bag that's bigger on the inside (Inscribed: one Bookspace charge, no Strain)
2. A collection of six innocuous-looking books, each containing one hidden item (player defines at session start)
3. A set of document-forging tools (inks, stamps, blank official papers)
4. A sailor's knife (well-used, well-maintained)
5. A compass that points toward the nearest concentration of magical writing
6. A wide-brimmed hat (hides her face; she's still technically wanted in two jurisdictions)

---

## Personality & Motivation

**Personality:** Wry, unhurried, practical. Has the calm confidence of someone who's talked her way past a hundred checkpoints. Enjoys good food, good drink, and good company. Judges people by their actions rather than their words (ironic for a Scribe). Has a maternal streak she'd deny having.

**Motivation:** One last job — there's always one last job. More honestly, Hazel is addicted to the puzzle of it: the planning, the execution, the satisfaction of moving the impossible from point A to point B without anyone noticing. She's also developed a sideline in smuggling people — refugees, escaped prisoners, persecuted Scribes — and that work gives her a moral justification she didn't used to need.

**Fear:** Getting caught. Not the punishment — the humiliation. Hazel's pride is in her craft, and getting outsmarted would hurt worse than any prison sentence.

---

## Unique Trait: Hidden Cargo

At the start of each session, Hazel's player can declare **3 small items** hidden in her book collection. These can be anything reasonable that she might have stashed "just in case" — a specific tool, a potion, a document, a weapon. The GM has veto power if an item is too powerful or implausible. This represents her smuggler's habit of always being prepared and makes her a versatile problem-solver with surprise resources.

---

## Playstyle

Hazel is a stealth and utility character who excels at smuggling, infiltration, hiding, and logistics. Her Inscription and Whispering combination is perfect for concealment, preparation, and misdirection. Her Hidden Cargo trait provides surprising versatility. Weaknesses are low Resolve (fragile, small Strain pool) and limited direct combat ability. Best played by someone who enjoys heist-style scenarios, creative problem-solving, and characters who always have a backup plan.
