# Torren Greyvault

**Concept:** Disenchanted academic who discovered that the Lexicon's history is a lie and can't stop digging

---

## Background

Professor Torren Greyvault held the Chair of Historical Linguistics at the Athenaeum of Deep Script for twelve years. He was respected, comfortable, and thoroughly institutionalized. Then he found the Palimpsest — a document that had been written over, erased, and rewritten dozens of times over centuries. Using a combination of Naming magic and obsessive scholarship, he recovered the original text beneath all the layers. What he found was a history of the Lexicon that contradicted everything taught in every academy: the Five Disciplines weren't discovered — they were imposed. The original language of magic had no divisions. Someone, long ago, deliberately fragmented it. And the Athenaeum knew. When Torren presented his findings, his tenure was revoked, his research was confiscated, and he was strongly encouraged to pursue other interests. He took the hint. He also took copies of everything.

---

## Attributes

| Attribute | Value |
|-----------|-------|
| **Voice** | 2 |
| **Script** | 5 |
| **Wit** | 3 |
| **Resolve** | 2 |

---

## Disciplines

- **Proficient:** Naming, Whispering

---

## Strain

**Maximum Strain:** 8 (Resolve 2 × 2 + 4)

---

## Starting Spells & Abilities

- **Palimpsest Reading** (Naming/Common) — Torren can perceive layers of meaning in any text, speech, or magical effect. He sees what was changed, what was hidden, and what was erased. On physical texts, this reveals overwritten content. On spoken words, it reveals the speaker's edits and hesitations. On magical effects, it reveals modifications and patches.
- **The Deeper Word** (Naming/Potent) — Torren reaches beneath the surface name of something and speaks its older, deeper name — the name it had before the Disciplines were divided. This produces unpredictable but often powerful effects, as the old magic doesn't follow the rules of the Five Disciplines.
- **Whisper Archive** (Whispering/Common) — Torren whispers a question, and the ambient text in his surroundings responds — signs, graffiti, discarded papers, book spines. The whispered answers are fragmentary and cryptic but often useful.

---

## Equipment

1. A leather satchel of copied research documents (Advantage on Script rolls related to history, linguistics, or institutional knowledge)
2. Reading glasses enchanted with Naming magic (reveal invisible or magically hidden text when worn)
3. A portable writing desk (foldable, fits in a pack — Resonant for Inscription, reducing Strain by 1)
4. Three volumes of comparative linguistic analysis (his own work, unpublished)
5. A hip flask of strong tea (technically just tea, but he treats it like whiskey)
6. A stout umbrella (doubles as a walking stick and, in emergencies, a weapon)

---

## Personality & Motivation

**Personality:** Professorial, absent-minded about practical matters, laser-focused on intellectual ones. Lectures when nervous. Gets excited about obscure etymological details at inappropriate moments. Surprisingly brave when his research is at stake — academic courage, he calls it. Self-deprecating humor. Terrible at reading social cues.

**Motivation:** The truth about the Lexicon's history. Who divided the original language of magic? Why? And what would happen if the divisions were undone? These questions consume him, and he'll follow the answers wherever they lead — even into danger he's spectacularly unequipped for.

**Fear:** That the truth he's uncovering will be worse than the lie — that the Disciplines were divided for a reason, and undoing them would be catastrophic.

---

## Unique Trait: Undisciplined Magic

Torren's research has given him a fragmentary understanding of the original, undivided language of magic. Once per session, he can attempt a spell that doesn't belong to any specific Discipline — an effect that blends multiple Disciplines or defies categorization entirely. This is always a Hard difficulty roll using Script, and the Strain cost is 3 regardless of the effect's scale. On a Triumph, the spell works perfectly and Torren gains insight into the old language (narrative reward). On a Failure, the magic behaves in unpredictable and potentially dangerous ways, as the old language doesn't follow the rules Torren expects.

---

## Playstyle

Torren is a pure scholar and investigator who excels at research, analysis, and uncovering hidden truths. His Naming magic is information-focused, and his Whispering complements it with ambient intelligence-gathering. Undisciplined Magic provides a high-risk wild card. His weaknesses are almost everything else — low Voice, low Resolve, poor in combat, and easily overwhelmed by physical challenges. Best played by someone who enjoys conspiracy narratives, academic characters in over their heads, and mysteries where the research IS the adventure.
