# Word & Will — Core Rules

## Overview

**Word & Will** is a solo tabletop RPG where magic flows from language itself — spoken, written, whispered, and willed into being. You play a Scribe: someone who has learned to shape reality through the power of words. Your AI Game Master (Claude) guides you through adventures in the **Lexicon**, a world built on the bones of forgotten languages.

---

## Core Attributes

Every character has four attributes, each rated from 1 (poor) to 5 (exceptional). Starting characters have **12 points** distributed across these attributes.

| Attribute | Governs |
|-----------|---------|
| **Voice** | Persuasion, intimidation, oration, spoken magic, social encounters |
| **Script** | Written magic, research, knowledge, deciphering, crafting inscriptions |
| **Wit** | Improvisation, quick thinking, combat reflexes, creative problem-solving |
| **Resolve** | Willpower, endurance, resisting magical effects, concentration, physical toughness |

---

## The Word Die

Word & Will uses a simple resolution system called a **Word Roll**.

### Making a Word Roll

When the outcome of an action is uncertain, the GM calls for a Word Roll:

1. The GM identifies the relevant **attribute** (Voice, Script, Wit, or Resolve).
2. The GM sets a **Threshold** based on difficulty:
   - **Simple** (2): Routine tasks under pressure
   - **Moderate** (3): Challenging but achievable
   - **Hard** (4): Requires real skill or luck
   - **Dire** (5): Near the edge of possibility
3. The GM simulates rolling **2d6** (two six-sided dice), adds the relevant attribute, and compares the total to the difficulty bands:

| Difficulty (Threshold) | Failure | Partial Success | Full Success | Triumph |
|------------------------|---------|-----------------|--------------|---------|
| **Simple (2)** | 6 or less | 7-8 | 9-11 | 12+ |
| **Moderate (3)** | 8 or less | 9-10 | 11-13 | 14+ |
| **Hard (4)** | 10 or less | 11-12 | 13-14 | 15+ |
| **Dire (5)** | 11 or less | 12-13 | 14-15 | 16+ |

**Example:** Moderate difficulty (Threshold 3) with Voice 4. GM rolls 2d6 and gets 8. Total = 8 + 4 = 12. On Moderate difficulty, 11-13 is a **Full Success**, so the action succeeds cleanly.

### Advantage and Disadvantage

Sometimes circumstances shift the odds:

- **Advantage**: Roll 3d6, drop the lowest die. (Favorable conditions, clever preparation, strong narrative positioning.)
- **Disadvantage**: Roll 3d6, drop the highest die. (Hostile conditions, injuries, working against your strengths.)

**Stacking:** Advantage and Disadvantage do not stack. No matter how many sources of Advantage or Disadvantage apply, you either have it or you don't. One source of each cancels both out. However, if a character has **three or more** distinct sources of Advantage (or Disadvantage), the GM may instead **reduce (or increase) the difficulty by one step** — e.g., from Moderate to Simple — to represent overwhelming circumstances.

---

## The Word-Magic System

### The Five Disciplines

All word-magic falls into five Disciplines. Each character begins with proficiency in **two Disciplines**.

**Proficiency** means full access — no restrictions on casting at any Spell Scale.

- **Off-discipline Cantrips:** Allowed. Resolve with a neutral **Wit** roll (no automatic Disadvantage from being off-discipline).
- **Off-discipline Common+ spells:** Not allowed by default. These only happen as **rare Player Innovation exceptions** at GM discretion.

| Discipline | Domain | Example Effects |
|------------|--------|-----------------|
| **Naming** | Knowing and speaking the true names of things | Reveal hidden truths, command objects, bind creatures |
| **Inscription** | Writing words of power onto surfaces or objects | Wards, enchantments, traps, lasting effects |
| **Rhetoric** | Shaping reality through persuasive speech | Inspire allies, demoralize foes, alter emotions, negotiate with spirits |
| **Whispering** | Subtle, quiet magic — eavesdropping, illusions, secrets | Stealth, information-gathering, misdirection, subtle influence |
| **Utterance** | Raw vocal power — shouts, battle cries, commands | Direct damage, shockwaves, barriers, force effects |

### Casting a Spell

There are no spell lists. Magic in Word & Will is **freeform and creative**. Here's how it works:

1. **Declare your intent.** Tell the GM what you want to accomplish and which Discipline you're using.
2. **Speak your spell.** Describe or quote the words your character uses. This is flavor — you don't need to write a sonnet, but a phrase, command, or inscription adds to the fiction. Even a brief description ("I whisper a word of unmaking") is enough.
3. **The GM determines the attribute and difficulty**, based on the Discipline and what you're attempting:
   - Naming, Inscription, Whispering → usually **Script**
   - Rhetoric → usually **Voice**
   - Utterance → usually **Voice** or **Resolve**
   - Creative or unconventional uses → **Wit**
4. **Make a Word Roll.**
5. **The GM narrates the result.**

### Spell Effort (Strain)

Magic costs **Strain**. Each character has a Strain track equal to **(Resolve × 2) + 4**.

| Spell Scale | Strain Cost |
|-------------|-------------|
| **Cantrip** — Minor, cosmetic, or trivial effect | 0 |
| **Common** — Standard useful magic | 1 |
| **Potent** — Powerful or complex effect | 2 |
| **Grand** — Major reality-altering magic | 3 |
| **Legendary** — World-shaking, desperate acts | 5 |

### Strain Thresholds

As you spend Strain, magic becomes harder to control:

- **Above half Strain:** No penalty. Magic flows freely.
- **At or below half Strain (Flagging):** The fiction reflects your fatigue — describe the effort, the sweat, the tremor in the voice — but no mechanical penalty. This is a warning signal.
- **At 0 Strain (Spent):** You can still attempt magic, but all spell rolls have **Disadvantage**. On a Failure, you take a **Wound** if the spell was Potent or higher. On Cantrip/Common spells, a Failure when Spent produces a narrative complication instead.

### Failed Magic Consequences

Not all failures are equal. When a spell fails, the severity of the consequence scales with the spell:

| Spell Scale | Failure Consequence |
|-------------|-------------------|
| **Cantrip** | Narrative flavor only — the magic fizzles, misfires cosmetically, or reveals something unintended |
| **Common** | A minor complication — unwanted attention, a small side effect, or the opposite of the intended result at reduced intensity |
| **Potent** | A significant complication — take 1 Strain backlash (if you have any), suffer a minor narrative setback, or alert a nearby threat. GM's choice based on context |
| **Grand** | Take **1 Wound** OR suffer a major narrative consequence (GM's choice). The magic was reaching for something big and reality pushed back |
| **Legendary** | Take **1 Wound** AND suffer a major narrative consequence. Magic at this scale is never safe, even for the gifted |

These consequences apply whether or not you are Spent. Being Spent makes the Wound threshold lower (any Potent+ failure causes a Wound), but even a healthy Scribe should fear a failed Grand spell.

### Resonance

When your spell's description is particularly clever, thematic, or dramatically appropriate, the GM may grant **Resonance** — a bonus that reduces the spell's Strain cost by 1 (minimum 0) or grants Advantage on the roll. Resonance rewards creativity and engagement with the word-magic theme.

**Resonance Triggers** (any one of these qualifies):
- You describe your spell with vivid, specific language — not just "I cast" but words your character actually speaks or writes.
- Your magic connects to your character's backstory, personality, or emotional state in the moment.
- You find an elegant or surprising solution that makes the GM think "that's perfect."
- You combine magic with the environment, an NPC's words, or another narrative element in a way that feels thematic.

**Player Requests:** Players may ask for Resonance if they feel their approach deserves it. The GM decides, but the request itself is encouraged — Resonance works best as a collaborative reward, not a gatekept bonus. Aim for **2–4 Resonance moments per session**.

---

## Health and Harm

### Wounds

Characters can endure **3 Wounds** before being **Broken**.

| Wound Count | Effect |
|-------------|--------|
| 0 | Healthy |
| 1 | Hurt — no mechanical penalty, but the fiction reflects it |
| 2 | Battered — Disadvantage on physical/Resolve rolls |
| 3 | **Broken** — Incapacitated. Without aid, the character is out of the story |

Wounds are inflicted by:
- Combat Failures or Partial Successes against Threat 3+ enemies (see Threat Rating table)
- Failed Grand or Legendary spells (see Failed Magic Consequences)
- Any spell failure when Spent, if the spell was Potent or higher
- Narrative hazards (traps, falls, environmental dangers)

### Recovery

- **Brief rest in safety** (a calm scene with actual medical care, shelter, or time) removes 1 Wound. Quick rests in hostile territory restore Strain but do NOT heal Wounds — you need genuine safety and care.
- **Healing magic** (Rhetoric to inspire vitality, Naming to speak wholeness) can remove 1 Wound with a Moderate spell roll, costing 2 Strain.
- **Full recovery** between adventures.
- **Broken (3 Wounds):** Recovering from Broken is harder. It requires either extended downtime (multiple rest scenes) or a Potent healing spell (Hard difficulty, 3 Strain). A character who was Broken carries a narrative scar — a limp, a stutter, a recurring nightmare — until they have a full recovery between adventures.

### Strain Recovery

- A **brief rest** (a calm scene, a moment of quiet) restores **Resolve** points of Strain.
- A **full rest** (extended downtime, sleep) restores all Strain.

---

## Combat

Combat in Word & Will is **narrative and fast**. There are no initiative rolls, grids, or turn orders.

### How Combat Works

1. **The GM sets the scene** — who's there, what's happening, what the threats are.
2. **You declare your action** — attack, defend, cast a spell, maneuver, flee, negotiate.
3. **The GM calls for a Word Roll** using the most relevant attribute.
4. **Results are narrated:**
   - **Triumph**: You achieve your goal and gain a tactical advantage.
   - **Full Success**: You achieve your goal cleanly.
   - **Partial Success**: You achieve your goal, but take a Wound, lose position, or face a complication.
   - **Failure**: You don't achieve your goal and suffer a consequence (Wound, lost ground, captured, etc.).
5. **Repeat** until the conflict resolves.

### Enemies and Threats

The GM assigns enemies a **Threat Rating** (1–5) that serves as the difficulty Threshold for actions against them. Enemies don't roll dice — their danger is expressed through the narrative and the Threshold they impose.

| Threat | Example |
|--------|---------|
| 1 | A common thug, a minor beast |
| 2 | A trained guard, a territorial creature |
| 3 | A skilled warrior, a dangerous predator, a lesser spirit |
| 4 | A master combatant, a powerful entity, a ward-heavy location |
| 5 | A legendary foe, an ancient power, a reality-bending threat |

#### What Threat Rating Determines

Threat Rating isn't just difficulty — it drives the entire shape of a combat encounter:

| Aspect | Threat 1–2 | Threat 3 | Threat 4–5 |
|--------|------------|----------|------------|
| **Difficulty Threshold** | Simple–Moderate | Moderate–Hard | Hard–Dire |
| **Progress to defeat** | 1 Full Success | 2 Full Successes (or 1 Triumph) | 3 progress (Full = 1, Triumph = 2) |
| **Damage on your Failure** | Complication or lost ground | 1 Wound | 1–2 Wounds or broken equipment |
| **Partial Success cost** | Minor inconvenience | Lost position or resource | 1 Wound or major complication |

For high-threat fights, a **Partial Success** can still count as 1 progress if the fiction supports it, but the listed Partial cost always applies. This keeps climactic encounters dangerous without turning them into slog.

**Groups:** When enemies fight as a coordinated group, increase the effective Threat Rating by 1 (to a maximum of 5). Six guards (individually Threat 2) fighting together act as Threat 3. The group is defeated when enough individual members fall to break their coordination — the GM narrates this based on the fiction.

**Triumphs in combat** should have outsized impact: instantly defeating a Threat 1–2 enemy, dealing double progress against a higher Threat, disarming an opponent, or creating a decisive tactical shift.

---

## Equipment and Inventory

Keep it simple. Characters carry:

- **Worn items** (armor, clothing, accessories) — described in their character sheet.
- **Carried items** (weapons, tools, supplies) — a character can comfortably carry **6 significant items**.
- **Inks and Quills** — Inscribers need writing materials. These are abstracted; you have them unless the story says otherwise.
- **Tomes and Scrolls** — May grant Advantage on specific Script rolls or provide one-use spell effects.

### Notable Equipment Tags

- **Warded**: Grants Advantage on Resolve rolls to resist one type of magic.
- **Inscribed**: Contains a pre-written spell that can be activated without a roll (one use).
- **Named**: A weapon or tool with a true name; grants +1 to rolls when used in its purpose.
- **Resonant**: Amplifies magic of a specific Discipline; reduces Strain by 1 for that Discipline.

---

## Character Progression

For one-hour sessions, progression is **narrative** rather than mechanical. However, the GM should track:

### Within a Session

- **Epiphanies**: If a character has a significant breakthrough (learning a secret, overcoming a fear, making a sacrifice), the GM may grant one of:
  - +1 Strain recovery
  - Temporary Advantage on a specific type of roll for the rest of the session
  - A new narrative capability (a new contact, a piece of knowledge, a minor magical item)

### Between Sessions (for Campaigns)

If players want to continue with the same character:

- After each session, gain **1 Advancement Point**.
- Spend 3 AP to increase one attribute by 1 (maximum 5).
- Spend 2 AP to gain proficiency in a new Discipline.
- Spend 1 AP to gain a new piece of notable equipment or a narrative boon.

---

## Chases

When fleeing or pursuing, use a structured chase:

1. **Set checkpoints.** The GM determines the length: **2 checkpoints** for a short chase (down a hallway, through a market), **3–4** for a longer one (across a district, through wilderness).
2. **At each checkpoint, roll.** Usually Wit (quick thinking, agility) or Resolve (endurance, determination), against the pursuer's Threat Rating as the difficulty Threshold.
3. **Results:**
   - **Triumph**: You gain so much distance you can escape immediately or catch your target outright.
   - **Full Success**: You clear the checkpoint and maintain or gain distance.
   - **Partial Success**: You advance, but with a complication — drop an item, take a Wound, the pursuer gets closer, or you're forced into a worse position.
   - **Failure**: Caught (if fleeing) or the target escapes (if pursuing). Alternatively, suffer a serious setback — cornered, injured, or forced to make a desperate choice.
4. **Magic in chases:** Players can spend Strain to use magic creatively at any checkpoint — Whispering to misdirect, Utterance to create a barrier, Inscription to activate a pre-written ward. A successful magic roll can substitute for the chase roll at that checkpoint, or grant Advantage on it.

---

## Sentient Objects and Living Artifacts

Some magical items in the Lexicon have personality, will, and agency. A living manuscript, a sword that remembers its wielders, a ward that has developed opinions — these are more NPC than equipment.

### Handling Sentient Objects

Treat sentient objects as NPCs with:

- **Disposition** (Hostile / Wary / Neutral / Friendly / Devoted): Starts based on how the character acquired the object and how they treat it. Shifts through interaction.
- **Requirements**: What the object needs to cooperate — respect, specific handling, a particular kind of user, or a goal it wants accomplished.
- **Limits**: What it refuses to do, regardless of the wielder's wishes. A pacifist sword might refuse to kill. A manuscript might withhold dangerous chapters.

### Using a Sentient Object Against Its Will

If a character tries to force a sentient object to comply, it requires a **Rhetoric roll** (to persuade) or **Naming roll** (to command via its true name) against a difficulty set by the object's willpower:

| Disposition | Difficulty |
|-------------|-----------|
| Devoted | Unnecessary — a Devoted object complies willingly and may anticipate your needs |
| Friendly | Simple — it wants to help, just needs a nudge |
| Neutral | Moderate — indifferent; convince it |
| Wary | Hard — suspicious; needs a good reason |
| Hostile | Dire — actively resisting; this is a battle of wills |

**Failure** when commanding a sentient object may cause it to **actively rebel** — withholding its power, providing wrong information, alerting enemies, or shutting down entirely. Sentient objects remember how they've been treated.

**Building rapport** with a sentient object over time shifts its Disposition upward. Treat it well, serve its goals, and it becomes a powerful ally. Abuse it, and it becomes your most dangerous liability.

---

## Social Encounters

### Information Tiers

In social scenes, information is available in tiers:

- **Free information:** Basic NPC descriptions, surface motivations, obvious emotions, and anything visible to a careful observer. No roll needed.
- **Available information:** Deeper motivations, hidden agendas, useful secrets. Requires a successful social roll — Rhetoric (persuasion or reading people), Whispering (eavesdropping or detecting subtlety), or Script (observing details, recalling knowledge). Difficulty is usually Moderate.
- **Guarded information:** Critical secrets, true names, vulnerabilities, and information NPCs are actively protecting. Requires a Hard roll, clever roleplay, or leverage (knowing something the NPC wants or fears).

### NPC Secrets

Each significant NPC in a scene should have **1–2 secrets** that clever play or successful rolls can reveal. Secrets should be genuinely useful — they change what the player can do, not just what they know.

### Roleplay and Rolls

Players can attempt to gather information through pure roleplay — asking the right questions, making the right connections, reading body language. When they do:
- If the approach is strong and the NPC would plausibly share, give the information without a roll.
- If the approach is reasonable but uncertain, call for a roll to confirm the accuracy and completeness.
- If the approach is a stretch, require a roll — and Failure means the NPC gives misleading or incomplete information (not "you learn nothing").

---

## Player Innovation

The freeform magic system means players will attempt things the rules don't explicitly cover. This is a feature, not a bug. When it happens:

### The Innovation Framework

1. **Determine the Discipline.** What kind of word-magic is this? If it spans multiple Disciplines, allow it with +1 Strain cost and proficiency requirements.
2. **Set difficulty based on narrative scope**, not just mechanical power. Doing something unprecedented is Hard. Doing something that breaks normal magical rules is Dire. Doing something creative within established boundaries might only be Moderate, even if the effect is powerful.
3. **Consider Resonance.** If the player's innovation is thematically perfect — if it makes you think "that's exactly what this system was designed for" — grant Resonance without hesitation.
4. **Let successes create new narrative facts.** A Triumph on an innovative spell doesn't just succeed — it establishes that this kind of magic is possible. The character has expanded what word-magic can do. This becomes part of the world's fiction going forward.
5. **Let failures create interesting complications, not dead ends.** A failed innovation should reveal something unexpected — the magic works differently than intended, attracts attention, or opens a door to a different solution. Never punish creativity with "nothing happens."

### Innovation and Proficiency Limits

Innovation does not erase Discipline identity. Use these boundaries:

- **Common+ off-discipline casting is exceptional, not routine.** Only allow it when the fiction strongly supports a breakthrough moment.
- If allowed, it should be **Hard or Dire**, cost **+1 Strain**, and carry clear narrative risk on a Partial or Failure.
- If those conditions are not met, the attempt fails safely or downgrades to a Cantrip-level effect.

### The Golden Rule

**Encourage wild swings.** The best magic in Word & Will comes from player creativity, not pre-defined spell lists. When a player invents something you didn't expect, that's the system working as intended. Say yes, set a fair difficulty, and see what happens.

---

## Quick Reference

| Term | Meaning |
|------|---------|
| **Word Roll** | 2d6 + Attribute vs. Threshold |
| **Advantage** | Roll 3d6, drop lowest (doesn't stack; 3+ sources = reduce difficulty instead) |
| **Disadvantage** | Roll 3d6, drop highest (doesn't stack; 3+ sources = increase difficulty instead) |
| **Strain** | Magic fuel; (Resolve × 2) + 4 |
| **Flagging** | At or below half Strain; narrative fatigue, no mechanical penalty |
| **Spent** | 0 Strain; spell rolls have Disadvantage; Potent+ failures cause Wounds |
| **Wounds** | Damage track; 3 = Broken |
| **Broken** | 3 Wounds; incapacitated; requires extended recovery |
| **Resonance** | Creativity bonus — player or GM can propose; reduces Strain by 1 or grants Advantage |
| **Threat Rating** | Enemy difficulty (1–5); also determines successes to defeat and damage on failure |
| **Disciplines** | Naming, Inscription, Rhetoric, Whispering, Utterance |
| **Disposition** | Sentient object or NPC attitude: Hostile → Wary → Neutral → Friendly → Devoted |
| **Checkpoints** | Chase structure: 2–4 rolls to resolve a pursuit |
| **Innovation** | Player attempts something outside the rules; GM sets Discipline, difficulty, and consequences |
